% Copyright 2014 Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000 with Sandia
% Corporation, the U.S. Government retains certain rights in this software
%
% This file is part of Sandia SPT (Sandia Simple Particle Tracking) v. 1.0.
% 
% Sandia SPT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% Sandia SPT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with Sandia SPT.  If not, see <http://www.gnu.org/licenses/>.

%script visualizeF2Ftrack
%
%PURPOSE:
%	viaualizeF2Ftrack.m 
%
%DEPENDENCIES:
%	-None-
%
%INPUTS: (implicit, as this is a script not a function)
%	(directory):
%		The directory to be analyzed, which should contain one file per
%		frame, named such that they appear sequentially in the directory. 
%	(files):
%		The individual files in the directory, in the proper order
%	(frame):
%		The frame number of the source frame
%	(sourcePos):
%		The xy-coordinates of the observations in the source frame in
%		columns
%	(sinkPos):
%		The xy-coordinates of the observations in the sink frame in
%		columns
%	(pairs):
%		Two columns, where the first column provides the indices of the
%		rows in sourcePos which were tracked to the rows in sinkPos
%		specified by the second column
%
%OUTPUTS:
%	This code will display a grayscale image of the second (sink) frame of 
%	the pair, with the observations from the first (source) frame 
%	superimposed as red xs and the observations from the second frame 
%	superimposed as blue circles. Green connecting lines indicate 
%	observations between the frames which were found to be paired. 
%
%LIMITATIONS:
%	-None-
%
%NOTES:
%	-None-
%
%Written by Stephen M. Anthony 08/21/2014
%Last modified on 08/21/14 by Stephen M. Anthony

%Read in and diaplay as grayscale the image of the sink frame
image = imread(fullfile(directory,files(frame+1).name));
imagesc(image);
set(gca,'DataAspectRatio',[1 1 1])
colormap('gray'); 

%Turn on superimpose mode
hold on

%Superimpose the positions from the source and sink frames as red x's and
%blue circles respectively
plot(sourcePos(:,1),sourcePos(:,2),'rx','LineWidth',2);
plot(sinkPos(:,1),sinkPos(:,2),'bo','LineWidth',2);

%Find those observations which were paired (or tracked) from one frame to
%the next
beg = sourcePos(pairs(:,1),:);
fin = sinkPos(pairs(:,2),:);

%Superimpose green lines connecting all observations paired (or tracked)
%from the source frame to the sink frame. 
plot([beg(:,1) fin(:,1)]',[beg(:,2) fin(:,2)]','g','LineWidth',2);

%Turn off superimpose mode
hold off
